
# Load required libraries
library(shiny)
library(tm)
library(wordcloud)
library(RColorBrewer)

# Define UI
ui <- fluidPage(
  titlePanel("Word Cloud Generator"),
  sidebarLayout(
    sidebarPanel(
      textAreaInput("text", "Enter your text here:", rows = 5),
      selectInput("color", "Choose a color scheme:", choices = colnames(brewer.pal.info), selected = "Dark2"),
      actionButton("generate", "Generate Word Cloud")
    ),
    mainPanel(
      plotOutput("wordcloudPlot")
    )
  )
)

# Define server
server <- function(input, output) {
  wordcloudPlot <- reactive({
    if (input$generate > 0) {
      text <- Corpus(VectorSource(input$text))
      text <- tm_map(text, content_transformer(tolower))
      text <- tm_map(text, removePunctuation)
      text <- tm_map(text, removeNumbers)
      text <- tm_map(text, removeWords, stopwords("en"))
      text <- tm_map(text, stripWhitespace)
      text <- tm_map(text, removeWords, c("the", "and", "in", "to", "for", "of", "a"))
      
      wordcloud(words = text, min.freq = 2, scale=c(3,0.3), colors=brewer.pal(8, input$color))
    }
  })
  
  output$wordcloudPlot <- renderPlot({
    wordcloudPlot()
  })
}

shinyApp(ui, server)
